function [stat_out,output,threshold,norm] = find_centroid_testrange(varargin)
%This is a high order script that allows you to run find_centroidvstk to
%look at a range of thresholds, for a range of normalizations.
%Synatax:   [] = find_centroid_testrange('dirname',array,'theshold',0.5,'type',2,'type2',1,'norm',1)
%Input:     'dirname' = directory where the images are, e.g., PSD95
%           'threshold' = if left off no threshold will be given, if given
%               the value should be between [0 1], and only maxima above
%               the desired level will be counted. Now by Default threshold
%               is 10% or 0.1 for localmax, centroids = 0.1 or 10%.  Now
%               the function will allow you to iterate through a number of
%               threshold you enter, essentially in the format:
%               (0.1,0.05...)  You should enter a range here for this
%               function. [0.05:0.05:0.5]  Meaning 0.05 to 0.5 by steps of
%               0.05.
%           type = 1(centroid), 2 (WeightedCentroid) or 0(local max),
%               default = 0(local max)
%           type2 = 1(Area), 2(Max Intensity), 3(Min Intensity, 4(Pixel #)
%                   default = 0(Mean Intensity) Note: only works with
%                   centroids
%           norm = normalize the images, essentially stretching the image
%                   data over the full bit range.  Only works in centroid
%                   mode.  Default = 1, or on, and will not affect the
%                   intensity  measurements, now matches threshold.  You
%                   should enter a range for this function, e.g., [0.99999,
%                   1, 0.999, 0.8...]
%           object = out put the images of the objects.  Default = 0(off)
%               Does not work with local max
%           zfilter = requires the objects to be in more than 1 z slice
%           Note: as this is setup currently, if there is a directory with
%           images that also contain directories, those images will not be
%           processed.  Images are only processed in end directories.
%           graph = graph the output.  Default = 1 (yes)
%           stk = You could enter the image stack if you want.
%           gnum = graph number, only used if you are graphing.
%           wavgroups = pregrouped data based on wavelength, if entered the
%               function will run in group mode.
%Output:    Output  = The matrix

[threshold,dirname,type,type2,norm,object,zfilter,graph,stk,gnum,wavgroups] = parse(varargin);

%initiate
match_stk = [];

for j = 1:size(norm,2)  %each norm
    for i = 1:size(threshold,2)  %each threshold
        [pivots_tmp,cc_tmp,stk,stk_bw] = find_centroidvstk('dirname',dirname,'type',type,'type2',type2,'object',object,...
            'threshold',threshold(i),'norm',norm(j),'zfilter',zfilter,'save',0,'stk',stk);
        num_tmp = size(pivots_tmp{1},1);   %get the number of centroids
        %save number of output
        output(j,i) = num_tmp;
        %lets do some stats
        if num_tmp~=0  %no pivots
            vol = pivots_tmp{1}(:,5);   %pull the volume parameter
            stat_out(1,i,j) = mean(vol);
            stat_out(2,i,j) = median(vol);
            stat_out(3,i,j) = mode(vol);
        else
            stat_out(1,i,j) = 0;
            stat_out(2,i,j) = 0;
            stat_out(3,i,j) = 0;
        end
        %lets look at the actual images generated
        object_idx = cell2mat(struct2cell(regionprops(cc_tmp{1},'PixelIdxList'))');    %grab the indexs of all of the pixels
        object_tmp = false(size(stk));    %stack holder
        object_tmp(object_idx) = 1;     %create the image
        object_img = object_tmp;   %store
        info = whos('stk');  %get the info for the stk
        imgclass = info.class;  %note you can get image size from this structure as well.
        switch imgclass
            case 'uint8'
                object_lum = stk.*uint8(object_img);   %preserve the luminance.
                curr_stk = stk.*uint8(stk_bw);  %grab the image stack at current threshold - for corrlation analysis
            case 'uint16'
                object_lum = stk.*uint16(object_img);   %preserve the luminance.
                curr_stk = stk.*uint16(stk_bw);  %grab the image stack at current threshold - for corrlation analysis
            case 'uint32'
                object_lum = stk.*uint32(object_img);   %preserve the luminance.
                curr_stk = stk.*uint32(stk_bw);  %grab the image stack at current threshold - for corrlation analysis
            case 'double'
                object_lum = stk.*double(object_img);   %preserve the luminance.
                curr_stk = stk.*double(stk_bw);  %grab the image stack at current threshold - for corrlation analysis
        end
        %calculate the entropy of the images
        %         stat_out(4,i,j) = entropy(object_img);
        stat_out(5,i,j) = entropy(object_lum);
        %         figure('Name',[num2str(i),' ',num2str(stat_out(4,i,j)),' entropy of object binary @threshold: ',num2str(threshold(i))],'NumberTitle','off',...
        %             'OuterPosition',[200 500 800 500]);
        %         imshow(object_img(:,:,8));
        %         figure('Name',[num2str(i),' ',num2str(stat_out(5,i,j)),' entropy of object grayscale @threshold: ',num2str(threshold(i))],'NumberTitle','off',...
        %             'OuterPosition',[1500 500 800 500]);
        %         imshow(object_lum(:,:,8));
        %clear!
        %calculate self correlation
        for k = 2:size(curr_stk,3)  %go through each image
            corr_tmp(k) = corr2(curr_stk(:,:,k-1),curr_stk(:,:,k));
        end
        stat_out(6,i,j) = nanmean(corr_tmp);  %output
%         %calculate accross threshold correlation
%         if i==1  %the first threshold
%             pre_stk = curr_stk;  %store and moveon
%             stat_out(7,i,j) = nan;  %empty
%         else
%             %now run the corr and calculate the mean core
%             for m = 1:size(curr_stk,3)
%                 corr_tmp(m) = corr2(pre_stk(:,:,m),curr_stk(:,:,m));
%             end
%             stat_out(7,i,j) = mean(corr_tmp);
%             pre_stk = curr_stk;
%         end
        %calculate accross threshold correlation to one singular threshold
        if i==1  %the first threshold
            for n = 1:size(stk,3)     %make the img Black & White
                pre_bw(:,:,n) = im2bw(stk(:,:,n),0.15);  %set compare threshold at 0.1
            end
            switch imgclass
                case 'uint8'
                    pre_stk = stk.*uint8(pre_bw);  %mask it
                case 'uint16'
                    pre_stk = stk.*uint16(pre_bw);  %mask it
                case 'uint32'
                    pre_stk = stk.*uint32(pre_bw);  %mask it
                case 'double'
                    pre_stk = stk.*double(pre_bw);  %mask it
            end
            stat_out(7,i,j) = nan;  %empty
        else
            %now run the corr and calculate the mean core
            for m = 1:size(curr_stk,3)
                corr_tmp(m) = corr2(pre_stk(:,:,m),curr_stk(:,:,m));
            end
            stat_out(7,i,j) = nanmean(corr_tmp);
            pre_stk = curr_stk;
        end
        %cross wavelength correlation
        if ~isempty(wavgroups)  %We need the wavgroups for this
            %parse the dirname
            sep_loc = find(dirname==filesep);  %find the seperator locations
            data_str = dirname(sep_loc(end)+1:end);  %take the text after the last seperator
            curr_cond = dirname(sep_loc(end-2):sep_loc(end-1));  %find the current experimental condition,e.g., WT/KO or AM/PM
            curr_region = dirname(sep_loc(end-1):sep_loc(end));   %find the current tissue region
            curr_exp = dirname(sep_loc(end-3):sep_loc(end-2));      %find the current experiment
            sesnum = data_str(1);  %get the image session session number  Format: 1 NR1 594 or 2 PSD95 594...
            wavnum = data_str(end-2:end);  %the last three are wavelength numbers
            %go forward if the wavelength is...
            if isempty(match_stk)
                match_dir = [];
                switch wavnum
                    case '647'
                        %grab the corresponding directory in 594
                        file_loc = wavgroups.lambda_594;
                    case '594'
                        file_loc = wavgroups.lambda_647;
                    otherwise
                        file_loc = [];
                end
                if ~isempty(file_loc)
                    [match_dir] = find_session(curr_exp,curr_cond,curr_region,sesnum,file_loc);
                    if ~isempty(match_dir)  %if there is a match
                        [match_stk] = openstk(match_dir);  %open the directory
                        match_bw = false(size(match_stk));
                        for l = 1:size(stk,3)     %make the img Black & White
                            try
                                match_bw(:,:,l) = im2bw(match_stk(:,:,l),0.1);  %set match threshold at 0.1
                            catch
                                keyboard
                            end
                        end
                        info = whos('match_stk');  %get the info for the stk
                        class_tmp = info.class;  %note you can get image size from this structure as well.
                        switch class_tmp
                            case 'uint8'
                                match_stk = match_stk.*uint8(match_bw);  %mask it
                            case 'uint16'
                                match_stk = match_stk.*uint16(match_bw);  %mask it
                            case 'uint32'
                                match_stk = match_stk.*uint32(match_bw);  %mask it
                            case 'double'
                                match_stk = match_stk.*double(match_bw);  %mask it
                        end
                    end
                end
            end
            if ~isempty(match_dir)  %must have a match to move forward
                %now run the corr and calculate the mean core
                for l = 1:size(curr_stk,3)
                    try
                        corr_tmp(l) = corr2(match_stk(:,:,l),curr_stk(:,:,l));
                    catch
                        keyboard
                    end
                end
                stat_out(8,i,j) = nanmean(corr_tmp);
            else
                %place holder
                stat_out(8,i,j) = nan;
            end
        else
            %place holder
            stat_out(8,i,j) = nan;
        end
        clear cc_tmp object_tmp object_img object_lum corr_tmp curr_stk corr_tmp
    end
    clear match_stk pre_stk pre_bw
    
    if graph
        %initialize graph tiling and dimensions
        set(0,'Units','pixels');
        scnsize = get(0,'ScreenSize');  %get current size
        x_tile = floor(scnsize(3)/3);
        y_tile = floor(scnsize(4)/3);
        x_size = x_tile*0.8;
        y_size = y_tile*0.8;
        x_border = (x_tile-x_size)/2;
        y_border = (y_tile-y_size)/2;
        pos1 = [x_border,y_tile*2+y_border,x_size,y_size];
        pos2 = [x_tile+x_border,y_tile*2+y_border,x_size,y_size];
        pos3 = [x_tile*2+x_border,y_tile*2+y_border,x_size,y_size];
        pos4 = [x_border,y_tile+y_border,x_size,y_size];
        pos5 = [x_tile+x_border,y_tile+y_border,x_size,y_size];
        pos6 = [x_tile*2+x_border,y_tile+y_border,x_size,y_size];
        pos7 = [x_border,y_border,x_size,y_size];
        pos8 = [x_tile+x_border,y_border,x_size,y_size];
        pos9 = [x_tile*2+x_border,y_border,x_size,y_size];
        %channel label
        dir_idx = find(dirname==filesep);  %where are all of slashes
        ch_name = dirname(dir_idx(end)+1:end);     %grab the channel protein name, e.g., PSD95
        if ~isempty(wavgroups)&&~isempty(match_dir)
            sep_loc = find(match_dir==filesep);  %parse the correlation match dir
            match_ch = match_dir(sep_loc(end)+1:end);  %take the text after the last seperator
        else
            match_ch = 'no match';
        end
        %plot the data centroid #
        figure('Name',[num2str(gnum),' ',ch_name,' Centroids# @ normalization: ',num2str(norm(j))],'NumberTitle','off','OuterPosition',pos1);
        plot(output(j,:));
        ylabel('# of centroids');
        xlabel('thresholds');
        set(gca,'XLim',[1 size(output,2)]);
        set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        idx = get(gca,'XTick');
        set(gca,'XTickLabel',threshold(idx));
%         %plot the data centroid volume mean
%         figure('Name',[num2str(gnum),' ',ch_name,' Centroids @ normalization: ',num2str(norm(j)),'-mean'],'NumberTitle','off','OuterPosition',pos2);
%         plot(stat_out(1,:,j));
%         ylabel('Mean pixel volume');
%         xlabel('thresholds');
%         set(gca,'XLim',[1 size(output,2)]);
%         %set(gca,'YLim',[1 50]);
%         set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
%         idx = get(gca,'XTick');
%         set(gca,'XTickLabel',threshold(idx));
        %plot the data centroid number curvature
        figure('Name',[num2str(gnum),' ',ch_name,' Centroids# @ normalization: ',num2str(norm(j)),'-curvature'],'NumberTitle','off','OuterPosition',pos2);
        k = cal_curve(output(j,:),1,2);
        plot(k);
        ylabel('curvature');
        xlabel('thresholds');
        set(gca,'XLim',[1 size(output,2)]);
        set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        idx = get(gca,'XTick');
        set(gca,'XTickLabel',threshold(idx));
%         %plot the data centroid volume median
%         figure('Name',[num2str(gnum),' ',ch_name,' Centroids @ normalization: ',num2str(norm(j)),'-median'],'NumberTitle','off','OuterPosition',pos3);
%         plot(stat_out(2,:,j));
%         ylabel('Median pixel volume');
%         xlabel('thresholds');
%         set(gca,'XLim',[1 size(output,2)]);
%         set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
%         idx = get(gca,'XTick');
%         set(gca,'XTickLabel',threshold(idx));
        %plot the data centroid volume mean
        figure('Name',[num2str(gnum),' ',ch_name,' object volume @ normalization: ',num2str(norm(j)),'-mean smooth'],'NumberTitle','off','OuterPosition',pos4);
        k = smooth(stat_out(1,:,j),'lowess');
        plot(k);
        ylabel('Mean pixel volume');
        xlabel('thresholds');
        set(gca,'XLim',[1 size(output,2)]);
        %set(gca,'YLim',[1 50]);
        set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        idx = get(gca,'XTick');
        set(gca,'XTickLabel',threshold(idx));
        %plot the data centroid volume mean curvature smooth
        figure('Name',[num2str(gnum),' ',ch_name,' object volume @ normalization: ',num2str(norm(j)),'-mean curvature smooth'],'NumberTitle','off','OuterPosition',pos7);
        k = cal_curve(k',1,1);
        plot(k);
        ylabel('curvature');
        xlabel('thresholds');
        set(gca,'XLim',[1 size(output,2)]);
        set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        idx = get(gca,'XTick');
        set(gca,'XTickLabel',threshold(idx));
%         %plot the data centroid number curvature
%         figure('Name',[num2str(gnum),' ',ch_name,' Centroids @ normalization: ',num2str(norm(j)),'-curvature'],'NumberTitle','off','OuterPosition',pos4);
%         k = cal_curve(output(j,:));
%         plot(k);
%         ylabel('curvature');
%         xlabel('thresholds');
%         set(gca,'XLim',[1 size(output,2)]);
%         set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
%         idx = get(gca,'XTick');
%         set(gca,'XTickLabel',threshold(idx));
        %plot the average correlation across each plane of the stack
        figure('Name',[num2str(gnum),' ',ch_name,' Correlation: ',num2str(norm(j)),'-self correlation across stack'],'NumberTitle','off','OuterPosition',pos3);
        plot(stat_out(6,:,j));
        ylabel('correlation');
        xlabel('thresholds');
        set(gca,'XLim',[1 size(output,2)]);
        set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        idx = get(gca,'XTick');
        set(gca,'XTickLabel',threshold(idx));
%         %plot the curvature of the average correlation across each plane of the stack
%         figure('Name',[num2str(gnum),' ',ch_name,' Correlation: ',num2str(norm(j)),'-self correlation across stack curvature'],'NumberTitle','off','OuterPosition',pos7);
%         k = cal_curve(stat_out(6,:,j),1,2);
%         plot(k);
%         ylabel('curvature');
%         xlabel('thresholds');
%         set(gca,'XLim',[1 size(output,2)]);
%         set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
%         idx = get(gca,'XTick');
%         set(gca,'XTickLabel',threshold(idx));
%         %plot the data centroid volume mean curvature smooth
%         figure('Name',[num2str(gnum),' ',ch_name,' Centroids @ normalization: ',num2str(norm(j)),'-mean curvature smooth'],'NumberTitle','off','OuterPosition',pos5);
%         k = cal_curve(stat_out(1,:,j));
%         k = smooth(k,'lowess');
%         plot(k);
%         ylabel('curvature');
%         xlabel('thresholds');
%         set(gca,'XLim',[1 size(output,2)]);
%         set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
%         idx = get(gca,'XTick');
%         set(gca,'XTickLabel',threshold(idx));
        %plot the smoothed mean correlation against the previuos threshold
        figure('Name',[num2str(gnum),' ',ch_name,' Correlation: ',num2str(norm(j)),'-smoothed mean corr against previous threshold'],'NumberTitle','off','OuterPosition',pos5);
        k = smooth(stat_out(7,:,j),'lowess');
        plot(k);
        ylabel('correlation');
        xlabel('thresholds');
        set(gca,'XLim',[1 size(output,2)]);
        set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        idx = get(gca,'XTick');
        set(gca,'XTickLabel',threshold(idx));
        %plot the smoothed curvature of mean correlation against the previuos threshold
        figure('Name',[num2str(gnum),' ',ch_name,' Correlation: ',num2str(norm(j)),'-smoothed mean corr against previous threshold curvature'],'NumberTitle','off','OuterPosition',pos8);
        k = smooth(stat_out(7,:,j),'lowess');
        k = cal_curve(k',1,1);
        plot(k);
        ylabel('curvature');
        xlabel('thresholds');
        set(gca,'XLim',[1 size(output,2)]);
        set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        idx = get(gca,'XTick');
        set(gca,'XTickLabel',threshold(idx));
%         %plot the data centroid volume mode
%         figure('Name',[num2str(gnum),' ',ch_name,' Centroids @ normalization: ',num2str(norm(j)),'-mode'],'NumberTitle','off','OuterPosition',pos6);
%         plot(stat_out(3,:,j));
%         ylabel('Mode pixel volume');
%         xlabel('thresholds');
%         set(gca,'XLim',[1 size(output,2)]);
%         set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
%         idx = get(gca,'XTick');
%         set(gca,'XTickLabel',threshold(idx));
        %plot the mean correlation against another wavelength
        figure('Name',[num2str(gnum),' ',ch_name,' vs. ',match_ch,' Correlation: ',num2str(norm(j)),'-smoothed against other wavelength'],'NumberTitle','off','OuterPosition',pos6);
        k = smooth(stat_out(8,:,j),'lowess');
        plot(k);
        ylabel('correlation');
        xlabel('thresholds');
        set(gca,'XLim',[1 size(output,2)]);
        set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        idx = get(gca,'XTick');
        set(gca,'XTickLabel',threshold(idx));
        %plot the curvature of mean correlation against another wavelength
        figure('Name',[num2str(gnum),' ',ch_name,' vs. ',match_ch,' Correlation: ',num2str(norm(j)),'-smoothed against other wavelength curvature'],'NumberTitle','off','OuterPosition',pos9);
        k = smooth(stat_out(8,:,j),'lowess');
        k = cal_curve(k',1,2);
        plot(k);
        ylabel('curvature');
        xlabel('thresholds');
        set(gca,'XLim',[1 size(output,2)]);
        set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        idx = get(gca,'XTick');
        set(gca,'XTickLabel',threshold(idx));
        %         %plot the data centroid number curvature smoothed
        %         figure('Name',[num2str(gnum),' ',ch_name,' Centroids @ normalization: ',num2str(norm(j)),'-curvature smooth'],'NumberTitle','off','OuterPosition',pos7);
        %         k = cal_curve(output(j,:));
        %         k = smooth(k,'lowess');
        %         plot(k);
        %         ylabel('curvature');
        %         xlabel('thresholds');
        %         set(gca,'XLim',[1 size(output,2)]);
        %         set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        %         idx = get(gca,'XTick');
        %         set(gca,'XTickLabel',threshold(idx));
        %         %plot the data centroid number delta
        %         figure('Name',[num2str(gnum),' ',ch_name,' Centroids @ normalization: ',num2str(norm(j)),'-delta'],'NumberTitle','off','OuterPosition',pos7);
        %         k = delta_curve(output(j,:));
        %         plot(k);
        %         ylabel('delta');
        %         xlabel('thresholds');
        %         set(gca,'XLim',[1 size(output,2)]);
        %         set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        %         idx = get(gca,'XTick');
        %         set(gca,'XTickLabel',threshold(idx));
        %         %plot the data volume median curvature smoothed
        %         figure('Name',[num2str(gnum),' ',ch_name,' Centroids @ normalization: ',num2str(norm(j)),'-median smooth'],'NumberTitle','off','OuterPosition',pos7);
        %         k = smooth(stat_out(2,:,j),'lowess');
        %         plot(k);
        %         ylabel('curvature');
        %         xlabel('thresholds');
        %         set(gca,'XLim',[1 size(output,2)]);
        %         set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        %         idx = get(gca,'XTick');
        %         set(gca,'XTickLabel',threshold(idx));
        %        %plot the data centroid volume mean curvature smoothed
        %         figure('Name',[num2str(gnum),' ',ch_name,' Centroids @ normalization: ',num2str(norm(j)),'-mean curvature mode'],'NumberTitle','off','OuterPosition',pos8);
        %         k = cal_curve(stat_out(1,:,j));
        %         k = smooth(k,'lowess');
        %         plot(k);
        %         ylabel('median');
        %         xlabel('thresholds');
        %         set(gca,'XLim',[1 size(output,2)]);
        %         set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        %         idx = get(gca,'XTick');
        %         set(gca,'XTickLabel',threshold(idx));
        %         %plot the data centroid volume mean delta
        %         figure('Name',[ch_name,' Centroids @ normalization: ',num2str(norm(j)),'-mean delta'],'NumberTitle','off','OuterPosition',pos8);
        %         k = delta_curve(stat_out(1,:,j));
        %         plot(k);
        %         ylabel('delta');
        %         xlabel('thresholds');
        %         set(gca,'XLim',[1 size(output,2)]);
        %         set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        %         idx = get(gca,'XTick');
        %         set(gca,'XTickLabel',threshold(idx));
        %         %plot the data centroid volume mean curvature smoothed
        %         figure('Name',[num2str(gnum),' ',ch_name,' Centroids @ normalization: ',num2str(norm(j)),'-entropy Object binary'],'NumberTitle','off','OuterPosition',pos8);
        %         plot(stat_out(4,:,j));
        %         ylabel('entropy');
        %         xlabel('thresholds');
        %         set(gca,'XLim',[1 size(output,2)]);
        %         set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        %         idx = get(gca,'XTick');
        %         set(gca,'XTickLabel',threshold(idx));
        %         %plot the data centroid volume mean curvature smoothed
        %         figure('Name',[num2str(gnum),' ',ch_name,' Centroids @ normalization: ',num2str(norm(j)),'-entropy Object grayscale curvature'],'NumberTitle','off','OuterPosition',pos8);
        %         k = cal_curve(stat_out(5,:,j));
        %         plot(k);
        %         ylabel('curvature');
        %         xlabel('thresholds');
        %         set(gca,'XLim',[1 size(output,2)]);
        %         set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        %         idx = get(gca,'XTick');
        %         set(gca,'XTickLabel',threshold(idx));
        %         %plot the data volume mode curvature smoothed
        %         figure('Name',[num2str(gnum),' ',ch_name,' Centroids @ normalization: ',num2str(norm(j)),'-mode smooth'],'NumberTitle','off','OuterPosition',pos9);
        %         k = smooth(stat_out(3,:,j),'lowess');
        %         plot(k);
        %         ylabel('mean');
        %         xlabel('thresholds');
        %         set(gca,'XLim',[1 size(output,2)]);
        %         set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        %         idx = get(gca,'XTick');
        %         set(gca,'XTickLabel',threshold(idx));
        %         %plot the data volume mode curvature smoothed
        %         figure('Name',[num2str(gnum),' ',ch_name,' Centroids @ normalization: ',num2str(norm(j)),'-entopy Object grayscale'],'NumberTitle','off','OuterPosition',pos9);
        %         plot(stat_out(5,:,j));
        %         ylabel('entropy');
        %         xlabel('thresholds');
        %         set(gca,'XLim',[1 size(output,2)]);
        %         set(gca,'XTick',[1:floor((size(output,2)-1)/10):size(output,2)]);
        %         idx = get(gca,'XTick');
        %         set(gca,'XTickLabel',threshold(idx));
    end
end

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [threshold,dirname,type,type2,norm,object,zfilter,graph,stk,gnum,wavgroups] = parse(input)

threshold = 0.05:0.05:0.5;
type = 0;
type2 = 0;      %default is 0; now you can define the accessory data, acquired instead of Luminance
norm = [0.9999,0.999,1];
object = 0;
dirname = [];
zfilter = 0;
graph = 1;
stk = [];
gnum = 1;
wavgroups = [];

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'dirname'
                    dirname = input{1,i+1};
                case 'threshold'
                    threshold = input{1,i+1};
                case 'type'
                    type = input{1,i+1};
                case 'type2'
                    type2 = input{1,i+1};
                case 'norm'
                    norm = input{1,i+1};
                case 'object'
                    object = input{1,i+1};
                case 'zfilter'
                    zfilter = input{1,i+1};
                case 'graph'
                    graph = input{1,i+1};
                case 'stk'
                    stk = input{1,i+1};
                case 'gnum'
                    gnum = input{1,i+1};
                case 'wavgroups'
                    wavgroups = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

%Get the location of the images you want to open
if isempty(dirname)
    dirname = uigetdir2('','Directory where your images are');    %get the directory
end

%--------------------------------------------------------------------------
%subfunction to calculate the curvature of a line

%the curvature of a circle drawn through three points is simply four times
%the area of the triangle formed by the three points divided by the product
%of its three sides. Using the coordinates of the points this is given by:

%K = 2*abs((x2-x1).*(y3-y1)-(x3-x1).*(y2-y1)) ./ ...
%  sqrt(((x2-x1).^2+(y2-y1).^2)*((x3-x1).^2+(y3-y1).^2)*((x3-x2).^2+(y3-y2).^2));

function [curvature] = cal_curve(line_data,absolute,rez)

if nargin<2
    absolute = 1;  %default turns absolute on
    rez = 1;
elseif nargin<3
    rez = 1;
end

%initiate x is always 1 2 3
x1 = 1;
x2 = 2;
x3 = 3;

%iterate through the line
for i = 1:size(line_data,2)
    y2 = line_data(i);
    if i<=rez
        y1 = nan;
    else
        y1 = line_data(i-rez);
    end
    if i+rez>size(line_data,2)
        y3 = nan;
    else
        y3 = line_data(i+rez);
    end
    switch absolute
        case 1  %absolute on
            curvature(i) = 2*abs((x2-x1).*(y3-y1)-(x3-x1).*(y2-y1)) ./ ...
                sqrt(((x2-x1).^2+(y2-y1).^2)*((x3-x1).^2+(y3-y1).^2)*((x3-x2).^2+(y3-y2).^2));
        otherwise  %no abs
            curvature(i) = 2*((x2-x1).*(y3-y1)-(x3-x1).*(y2-y1)) ./ ...
                sqrt(((x2-x1).^2+(y2-y1).^2)*((x3-x1).^2+(y3-y1).^2)*((x3-x2).^2+(y3-y2).^2));
    end
end

%--------------------------------------------------------------------------
%subfunction to create a delta curve
%A plot of the difference between sucessive points
function [delta] = delta_curve(line_data)

%iterate through the line
for i = 1:size(line_data,2)-1
    delta(i) = line_data(i)-line_data(i+1);
end

%--------------------------------------------------------------------------
%find the corresponding session file in another wavelength
function [match_dir] = find_session(curr_exp,curr_cond,curr_region,sesnum,file_loc)
match_dir = [];  %default output
for i = 1:size(file_loc,1)
    %parse and find
    sep_loc = find(file_loc{i}==filesep);  %find the seperator locations
    data_str = file_loc{i}(sep_loc(end)+1:end);  %take the text after the last seperator
    cond_tmp = file_loc{i}(sep_loc(end-2):sep_loc(end-1));  %find the current experimental condition,e.g., WT/KO or AM/PM
    region_tmp = file_loc{i}(sep_loc(end-1):sep_loc(end));   %find the current tissue region
    exp_tmp = file_loc{i}(sep_loc(end-3):sep_loc(end-2));      %find the current experiment
    %a match on all fronts is needed
    if strcmpi(sesnum,data_str(1))&&strcmpi(curr_cond,cond_tmp)&&strcmpi(curr_region,region_tmp)&&strcmpi(curr_exp,exp_tmp)
        match_dir = file_loc{i};
        break
    end
end

%--------------------------------------------------------------------------
function [stk] = openstk(dirname)
%grab the filenames in the directory
dir_struct = dir(dirname);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
filenames = {dir_struct.name};   %grab the all of the names in the root
filenames = filenames(~idx);  %don't want the directory names

%Put the virtual stack into an actual volume
[filenames] = findimgs(filenames);   %make sure we only take the image names
info = imfinfo([dirname,filesep,filenames{1}]);     %grab the file info
switch info.BitDepth    %what is the bit depth
    case 8
        imgclass = 'uint8';
    case 16
        imgclass = 'uint16';
    case 32
        imgclass = 'uint32';
    otherwise
        imgclass = 'double';
end

stk = zeros(info.Height,info.Width,size(filenames,2),imgclass); %generate holder variable

h = waitbar(0,'Opening Image: ','position',[10 50 275 50]);     %initiate progress bar
for i = 1:size(filenames,2)
    waitbar(i/size(filenames,2),h,['Opening Image: ',filenames{i}]);   %update progress
    stk(:,:,i) = imread([dirname,filesep,filenames{i}]);  %grab the image
end
close(h)